<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Podcast;
use App\Http\Requests\API\Therapists\TherapistPodcasts\CreateRequest;
use App\Http\Resources\API\PodcastsResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistPodcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_podcasts.index');
      // $this->middleware('permission:therapist_podcasts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_podcasts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_podcasts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_podcasts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_podcasts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_podcasts.update|therapist_podcasts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_podcasts =  $therapist->therapist_podcasts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_podcasts =  $therapist_podcasts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_podcasts =  $therapist_podcasts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_podcasts = $therapist_podcasts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_podcasts = $therapist_podcasts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_podcasts = $therapist_podcasts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_podcasts = $therapist_podcasts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_podcasts = $therapist_podcasts->get();
        return $therapist_podcasts;
      }
      $totalTherapistCertifications = $therapist_podcasts->count();
      $therapist_podcasts = $therapist_podcasts->paginate($req->perPage);
      $therapist_podcasts = PodcastsResource::collection($therapist_podcasts)->response()->getData(true);

      return $therapist_podcasts;
    }
    $therapist_podcasts = PodcastsResource::collection($therapist->therapist_podcasts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_podcasts;
  }

  /********* FETCH ALL TherapistPodcasts ***********/
    public function index()
    {
        $therapist_podcasts =  $this->getter();
        $response = generateResponse($therapist_podcasts,count($therapist_podcasts['data']) > 0 ? true:false,'TherapistPodcasts Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistPodcasts FOR Search ***********/
   public function filter(Request $request){
     $therapist_podcasts = $this->getter($request);
     $response = generateResponse($therapist_podcasts,count($therapist_podcasts['data']) > 0 ? true:false,'Filter TherapistPodcasts Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistPodcast ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['created_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadFile($request,'image','therapist_podcasts');
        $data['audio'] = uploadFile($request,'audio','therapist_podcasts');
        $data['video'] = uploadFile($request,'video','therapist_podcasts');
        $therapist_podcast = $therapist->therapist_podcasts()->create($data);
        $therapist_podcast->slug = Str::slug($therapist_podcast->name . ' ' . $therapist_podcast->id, '-');
        $therapist_podcast->save();
        $therapist_podcast->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_podcast = $therapist->therapist_podcasts()->withAll()->find($therapist_podcast->id);
        $therapist_podcast = new PodcastsResource($therapist_podcast);
      $response = generateResponse($therapist_podcast,true ,'TherapistPodcasts Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Podcast $therapist_podcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_podcast = $therapist->therapist_podcasts()->withAll()->find($therapist_podcast->id);
        if($therapist_podcast){
          $therapist_podcast = new PodcastsResource($therapist_podcast);
          $response = generateResponse($therapist_podcast,true,'TherapistPodcast Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistPodcast Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistPodcast ***********/
    public function update(CreateRequest $request, Podcast $therapist_podcast)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadFile($request,'image','therapist_podcasts',$therapist_podcast->image);
        } else {
            $data['image'] = $therapist_podcast->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_podcasts');
        } else {
            $data['audio'] = $therapist_podcast->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_podcasts');
        } else {
            $data['video'] = $therapist_podcast->video;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_podcast->id, '-');

        $therapist_podcast->update($data);
        $therapist_podcast->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_podcast = $therapist->therapist_podcasts()->withAll()->find($therapist_podcast->id);
        $therapist_podcast = new PodcastsResource($therapist_podcast);
        $response = generateResponse($therapist_podcast,true,'TherapistPodcast Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistPodcast Status***********/
    public function updateStatus(Request $request,Podcast $therapist_podcast){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_podcast->update([
          'is_active' => $therapist_podcast->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistPodcast Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistPodcast ***********/
    public function destroy(Request $request,Podcast $therapist_podcast)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_podcast->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_podcast->delete();
          }
          $response = generateResponse(null,true,'TherapistPodcast Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistPodcast ***********/
    public function destroyPermanently(Request $request,$therapist_podcast)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_podcast = $therapist->therapist_podcasts()->withTrashed()->find($therapist_podcast);
        if($therapist_podcast){
            if($therapist_podcast->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_podcast->trashed()) {
            $therapist_podcast->forceDelete();
            $response = generateResponse(null,true,'TherapistPodcast Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPodcast is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistPodcast not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistPodcast ***********/
    public function restore(Request $request,$therapist_podcast)
    {
      $therapist= auth()->user()->therapist;
      $therapist_podcast = $therapist->therapist_podcasts()->withTrashed()->find($therapist_podcast);
          if ($therapist_podcast->trashed()) {
            $therapist_podcast->restore();
            $response = generateResponse(null,true,'TherapistPodcast Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPodcast is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
